import java.util.*;
import acm.util.*;

public class GeneralCardDeck {

    // Object to generate random numbers for deck shuffling
    private RandomGenerator rgen = RandomGenerator.getInstance();

    /* A list of all cards still in the deck.  The last element
     * is the "top", and the first element is the "bottom".
     */
    private ArrayList<String> cards;

    public GeneralCardDeck(int numValues, int numSuits) {
        cards = new ArrayList<String>();
        
        // Also OK to loop over values first, and then suits
        for (int suit = 0; suit < numSuits; suit++) {
            for (int value = 0; value < numValues; value++) {
                char suitChar = (char)('A' + suit);
                char valueChar = (char)('1' + value);
                cards.add("" + valueChar + suitChar);
            }
        }
    }

    public void shuffle() {
        for (int i = 0; i < 100; i++) {
            int position1 = rgen.nextInt(cards.size());
            int position2 = rgen.nextInt(cards.size());
            String card1 = cards.get(position1);
            String card2 = cards.get(position2);
            cards.set(position1, card2);
            cards.set(position2, card1);
        }
    }

    public String getNextCard() {
        if (cards.isEmpty()) {
            return "";
        }

        String nextCard = cards.get(cards.size() - 1);
        cards.remove(cards.size() - 1);
        return nextCard;
        // Can also say return cards.remove(cards.size() - 1);
    }

    public int getNumRemaining() {
        return cards.size();
    }

    public boolean isEmpty() {
        return cards.isEmpty();
    }
}
